; Esercizio n4   ------------- AMBITO: automazione uso civile ------------
; TITOLO: Tennis    
;------------------------------------------------------------------------------
;|Finalit:  A- Ancora codificare iterazioni definite e iterazione indefinite,|
;|*********     gestire l'acquisizione e la trasmissione di dati a singoli bit|
;|              creazione e gestione di un ciclo di ritardo.                  | 
;|           B- Imparare a gestire calcoli con dati a 16 bit.                 |
;|           C- Imparare a gestire il confronto di dati a 16 bit .            |
;|                                                                            |
;|Obiettivi: A- Codifica del programma attraverso il diagramma di flusso;     |
;|********** B- Uso delle istruzioni di assegnazioni e  salto condizionato    |
;|              semplice e con decremento.                                    |
;|           C- Calcolare il tempo trascorso tra lattivazione di una coppia  |
;|              di fotocellule e laltra.                                     |
;|           D- Confrontare il risultato ottenuto con un valore di riferimento|
;|           E- Scelta di attivazione uscita in base al risultato ottenuto    |
;|           F- Uso delle istruzioni di : moltiplicazione, confronto e        |
;|              controllo del bit di riporto (carry).                         |
;|Enunciato: Un atleta si allena da solo su un campo da tennis con su 2       |                  
;|********** attrezzi che sparano palline alla  velocit di 80Km/h il primo,  |
;|           50Km/ il secondo, per un massimo di 20 palline ciascuno. La      |  
;|           velocit del tiro del tennista  rilevata da due coppie di       |
;|           fotocellule (trasmettitore + ricevitore S1 e trasmettitore +     | 
;|           ricevitore S2), poste ad una distanza di 5cm . Se il tiro del    |
;|           tennista supera i 30 km/h, si azioner cannone 1, altrimenti si  |
;|           attiver il numero 2.  La prima palla  in mano al giocatore. Il |
;|           suono di una sirena segnala che uno dei caricatori  vuoto.      |
;------------------------------------------------------------------------------


;programma:

;TABELLA DI ASSEGANZIONE PIN:

; C1			R0	
; C2			R1
; N			R2
; Tc			R3
; TP			R4,R5
; T rif		44H	R6
;		45H	R7
; F1			P1.0
; F2			P1.1
; A1			P1.2
; A2			P1.3
; S			P1.4



$MOD51
ORG 1000H

INIZIALIZZAZIONE:	MOV R0, #20		;assegno al caricatore C1 il valore 20
			MOV R1, #20		;assegno al caricatore C2 il valore 20
			MOV R2, #0		;assegno al contatore del ciclo F2 il valore 0
			MOV R3, #6		; il tempo necessario a compiere il ciclo F2
			SETB P1.2		;spengo il cannone numero 1
			SETB P1.3		;spengo il cannone numero 2
			MOV R6, #04H		;sposto in r6 il valore + significativo del t rif
			MOV R7, #0B0H		;sposto in r7 il valore - significativo del t rif
						;
START:			JB P1.0, START		;se non  attivo torna a start
						;
CONTA:			INC R2			;incrementa di uno R2
			NOP			;nessuna operazione
			NOP			;nessuna operazione
			NOP			;nessuna operazione
			JB P1.1, CONTA		;torna a conta se la seconda fotocellula  ancora disattiva
						;
TP:			MOV A, R2		;sposta il contatore del ciclo f2 nell'accumulatore
			MOV B, #6		;sposta tc nel registro B 
			MUL AB			;moltiplica a con b
			PUSH Acc		;sposta momentaneamente A nel stack 
			MOV A, B		;sposta b nell'accomulatore
			CJNE A, 6, CARRY	;
			POP Acc 
			CJNE A, 7, CARRY
			JMP MINORE

CARRY:			JC VELOCE

MINORE:			CLR P1.3
			DJNZ R1, FINE
			CLR P1.4
			JMP FINE

VELOCE:			CLR P1.2
			DJNZ R0, FINE
			CLR P1.4

FINE:			JB P1.5, START

		END	